<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.924154805 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-X4" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexX4CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexX4INST_RETIRED / $InstructionsPerCycleCortexX4CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexX4CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexX4STALL_FRONTEND / $FrontendStalledCyclesCortexX4CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexX4CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexX4STALL_BACKEND / $BackendStalledCyclesCortexX4CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundCortexX4CPU_CYCLES &gt; 0), min((($FrontendBoundCortexX4STALL_SLOT_FRONTEND / (10 * $FrontendBoundCortexX4CPU_CYCLES)) - ($FrontendBoundCortexX4STALL_FRONTEND_FLUSH / $FrontendBoundCortexX4CPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
        <series color="255,0,229" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexX4CPU_CYCLES &gt; 0), min(($BackendBoundCortexX4STALL_SLOT_BACKEND / (10 * $BackendBoundCortexX4CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexX4CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexX4OP_SPEC &gt; 0), min(((1 - ($RetiringCortexX4STALL_SLOT / ($RetiringCortexX4CPU_CYCLES * 10))) * ($RetiringCortexX4OP_RETIRED / $RetiringCortexX4OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
        <series color="0,255,25" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationCortexX4CPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationCortexX4OP_SPEC &gt; 0), min((((1 - ($BadSpeculationCortexX4STALL_SLOT / (10 * $BadSpeculationCortexX4CPU_CYCLES))) * (1 - ($BadSpeculationCortexX4OP_RETIRED / $BadSpeculationCortexX4OP_SPEC))) + ($BadSpeculationCortexX4STALL_FRONTEND_FLUSH / $BadSpeculationCortexX4CPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexX4OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexX4OP_RETIRED / $RetiredOperationsPercentageCortexX4OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundCortexX4STALL_FRONTEND &gt; 0), min(($FrontendCoreBoundCortexX4STALL_FRONTEND_CPUBOUND / $FrontendCoreBoundCortexX4STALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundCortexX4STALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundCortexX4STALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundCortexX4STALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Core Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundCortexX4STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundCortexX4STALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundCortexX4STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundCortexX4STALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundCortexX4STALL_FRONTEND_FLOW / $FrontendCoreFlowBoundCortexX4STALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Memory Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundCortexX4STALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundCortexX4STALL_FRONTEND_L1I + $FrontendMemCacheBoundCortexX4STALL_FRONTEND_MEM) / $FrontendMemCacheBoundCortexX4STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundCortexX4STALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundCortexX4STALL_FRONTEND_TLB / $FrontendMemTLBBoundCortexX4STALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Frontend (Frontend Mem Cache Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundCortexX4STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexX4STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundCortexX4STALL_FRONTEND_L1I / ($FrontendCacheL1IBoundCortexX4STALL_FRONTEND_L1I + $FrontendCacheL1IBoundCortexX4STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundCortexX4STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexX4STALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundCortexX4STALL_FRONTEND_MEM / ($FrontendCacheL2IBoundCortexX4STALL_FRONTEND_L1I + $FrontendCacheL2IBoundCortexX4STALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexX4INST_RETIRED &gt; 0), (($L1ICacheMPKICortexX4L1I_CACHE_REFILL / $L1ICacheMPKICortexX4INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Cache L1I Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexX4L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexX4L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexX4L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexX4INST_RETIRED &gt; 0), (($ITLBMPKICortexX4ITLB_WALK / $ITLBMPKICortexX4INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexX4INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexX4L1I_TLB_REFILL / $L1InstructionTLBMPKICortexX4INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexX4L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexX4ITLB_WALK / $ITLBWalkPercentageCortexX4L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageCortexX4L1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageCortexX4ITLB_WALK_LARGE / $ITLBWalkLargePagePercentageCortexX4L1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageCortexX4L1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageCortexX4ITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageCortexX4L1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexX4L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexX4L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexX4L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesCortexX4ITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesCortexX4ITLB_STEP / $ITLBWalkAverageDepthOfAccessesCortexX4ITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Mem TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyCortexX4ITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyCortexX4ITLB_WALK_PERCYC / $ITLBWalkAverageLatencyCortexX4ITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundCortexX4STALL_BACKEND &gt; 0), min(($BackendCoreBoundCortexX4STALL_BACKEND_CPUBOUND / $BackendCoreBoundCortexX4STALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundCortexX4STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexX4STALL_BACKEND_MEMBOUND / $BackendMemoryBoundCortexX4STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend as the rename unit registers are unavailable" expression="if(($BackendCoreRenameBoundCortexX4STALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreRenameBoundCortexX4STALL_BACKEND_RENAME / $BackendCoreRenameBoundCortexX4STALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core Rename Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Core Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundCortexX4STALL_BACKEND &gt; 0), min(($BackendBusyBoundCortexX4STALL_BACKEND_BUSY / $BackendBusyBoundCortexX4STALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemoryCacheBoundCortexX4STALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemoryCacheBoundCortexX4STALL_BACKEND_L1D + $BackendMemoryCacheBoundCortexX4STALL_BACKEND_MEM) / $BackendMemoryCacheBoundCortexX4STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Cache Bound" units="percent"/>
        <series color="153,0,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemoryTLBBoundCortexX4STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryTLBBoundCortexX4STALL_BACKEND_TLB / $BackendMemoryTLBBoundCortexX4STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory TLB Bound" units="percent"/>
        <series color="0,255,153" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemoryStoreBoundCortexX4STALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemoryStoreBoundCortexX4STALL_BACKEND_ST / $BackendMemoryStoreBoundCortexX4STALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory Store Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Memory Cache Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundCortexX4STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexX4STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundCortexX4STALL_BACKEND_L1D / ($BackendCacheL1DBoundCortexX4STALL_BACKEND_L1D + $BackendCacheL1DBoundCortexX4STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundCortexX4STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexX4STALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundCortexX4STALL_BACKEND_MEM / ($BackendCacheL2DBoundCortexX4STALL_BACKEND_L1D + $BackendCacheL2DBoundCortexX4STALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexX4INST_RETIRED &gt; 0), (($L1DCacheMPKICortexX4L1D_CACHE_REFILL / $L1DCacheMPKICortexX4INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Cache L1D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexX4L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexX4L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexX4L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexX4INST_RETIRED &gt; 0), (($L2CacheMPKICortexX4L2D_CACHE_REFILL / $L2CacheMPKICortexX4INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexX4L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexX4L2D_CACHE_REFILL / $L2CacheMissPercentageCortexX4L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexX4INST_RETIRED &gt; 0), (($L3CacheMPKICortexX4L3D_CACHE_REFILL / $L3CacheMPKICortexX4INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexX4L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexX4L3D_CACHE_REFILL / $L3CacheMissPercentageCortexX4L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexX4INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexX4LL_CACHE_MISS_RD / $LLCacheReadMPKICortexX4INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Cache L2D Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexX4LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexX4LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexX4LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexX4LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexX4LL_CACHE_RD - $LLCacheReadHitPercentageCortexX4LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexX4LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexX4INST_RETIRED &gt; 0), (($DTLBMPKICortexX4DTLB_WALK / $DTLBMPKICortexX4INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexX4INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexX4L1D_TLB_REFILL / $L1DataTLBMPKICortexX4INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexX4INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexX4L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexX4INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexX4L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexX4DTLB_WALK / $DTLBWalkPercentageCortexX4L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="255,0,153" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageCortexX4L1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageCortexX4DTLB_WALK_LARGE / $DTLBWalkLargePagePercentageCortexX4L1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
        <series color="51,0,255" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageCortexX4L1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageCortexX4DTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageCortexX4L1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
        <series color="0,255,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexX4L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexX4L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexX4L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="51,255,0" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexX4L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexX4L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexX4L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesCortexX4DTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesCortexX4DTLB_STEP / $DTLBWalkAverageDepthOfAccessesCortexX4DTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Memory TLB Bound) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyCortexX4DTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyCortexX4DTLB_WALK_PERCYC / $DTLBWalkAverageLatencyCortexX4DTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexX4INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexX4ISB_SPEC + $BarrierOperationsPercentageCortexX4DSB_SPEC) + $BarrierOperationsPercentageCortexX4DMB_SPEC) / $BarrierOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexX4INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexX4BR_IMMED_SPEC + $BranchOperationsPercentageCortexX4BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexX4INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexX4CRYPTO_SPEC / $CryptoOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexX4INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexX4DP_SPEC - $IntegerOperationsPercentageCortexX4DSB_SPEC) / $IntegerOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexX4INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexX4LDST_SPEC / $LoadStoreOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexX4INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexX4VFP_SPEC / $FloatingPointOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexX4INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexX4ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,0,51" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexX4INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexX4SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexX4INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexX4INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexX4FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexX4INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexX4INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexX4FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexX4INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexX4INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexX4FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexX4INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexX4INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexX4LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexX4INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexX4INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexX4STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexX4INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexX4LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexX4LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexX4LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexX4LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexX4ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexX4LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexX4INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexX4LD_SPEC / $LoadOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexX4INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexX4ST_SPEC / $StoreOperationsPercentageCortexX4INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retiring) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexX4INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexX4RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexX4INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexX4INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexX4RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexX4INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Bad Speculation) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexX4INST_RETIRED &gt; 0), (($BranchMPKICortexX4BR_MIS_PRED_RETIRED / $BranchMPKICortexX4INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Bad Speculation) (Cortex-X4)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexX4BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexX4BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexX4BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
        <series color="255,0,229" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexX4BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexX4BR_IMMED_RETIRED / $BranchDirectPercentageCortexX4BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageCortexX4BR_RETIRED &gt; 0), min(($BranchIndirectPercentageCortexX4BR_IND_RETIRED / $BranchIndirectPercentageCortexX4BR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
        <series color="0,255,25" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexX4BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexX4BR_RETURN_RETIRED / $BranchReturnPercentageCortexX4BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv9_Cortex_X4_metric_backend_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_busy_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_core_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_core_rename_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_mem_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_X4_metric_bad_speculation" />
    <select-metric id="ARMv9_Cortex_X4_metric_barrier_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_branch_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_branch_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_branch_return_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_crypto_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_dtlb_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_X4_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_X4_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_fp16_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_fp32_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_fp64_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_core_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_Cortex_X4_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_Cortex_X4_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_ipc" />
    <select-metric id="ARMv9_Cortex_X4_metric_itlb_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_Cortex_X4_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_Cortex_X4_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_ldrex_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_Cortex_X4_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_Cortex_X4_metric_load_ls_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_load_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_load_store_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_rc_st_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_retired_ops_percent" />
    <select-metric id="ARMv9_Cortex_X4_metric_retiring" />
    <select-metric id="ARMv9_Cortex_X4_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_simd_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_store_ls_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_store_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_strex_percentage" />
    <select-metric id="ARMv9_Cortex_X4_metric_sve_all_percentage" />
</template>
